library(PopGenome)

#define populations and calc neutrality stats per pop
seqs<-readData('alignments') #alignments should be the directory of your input files
seqs<-set.populations(seqs,list(1:63,64:77))
seqs<-neutrality.stats(seqs)
get.neutrality(seqs)[1]
get.neutrality(seqs)[2]

#sliding window
seqs.slide=sliding.window.transform(seqs,width=500,jump=100,type=2)
seqs.slide<-neutrality.stats(seqs.slide)
get.neutrality(seqs.slide,theta=T,stats=F)[1]
get.neutrality(seqs.slide,theta=T,stats=F)[2]

#plot diversity
stats<-get.neutrality(seqs.slide,theta=T)
plot(stats[[2]][,1],type='l',col='blue',ylim=c(-2.5,0))
lines(stats[[1]][,1],pch=2,col='red')
plot(stats[[2]][,10],type='l',col='blue',ylab='pi')
lines(stats[[1]][,10],pch=2,col='red')
